<?php $__env->startSection('content'); ?>
<input type="hidden" id="headerdata" value="<?php echo e(__('CATEGORY')); ?>">
<input type="hidden" id="attribute_data" value="<?php echo e(__('ADD NEW ATTRIBUTE')); ?>">
<div class="content-area">
    <div class="mr-breadcrumb">
        <div class="row">
            <div class="col-lg-12">
                <h4 class="heading"><?php echo e(__('All Posts')); ?></h4>
                <ul class="links">
                    <li>
                        <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo e(__('Dashboard')); ?> </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('user.post.index')); ?>"><?php echo e(__('Posts')); ?></a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <div class="product-area">
        <div class="row">
            <div class="col-sm-2 m-3">
                <label ><b><?php echo e(__('Language')); ?></b></label>
                <select  id="filter_lang">
                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option data-href="<?php echo e(route('user.post.datatables')); ?>?lang=<?php echo e($language->id); ?>" value="<?php echo e($language->id); ?>" <?php echo e($language->is_default==1 ? 'selected':''); ?>><?php echo e($language->language); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-sm-2 m-3">
                <label ><b><?php echo e(__('Category')); ?></b></label>
                <select id="category_id" >

                </select>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="mr-table allproduct">
                    <?php echo $__env->make('includes.admin.form-success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('includes.admin.flash-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="table-responsiv">
                        <table id="geniustable" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Image')); ?></th>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Category')); ?></th>
                                    <th><?php echo e(__('Language')); ?></th>
                                    <th><?php echo e(__('Post Type')); ?></th>
                                    <th><?php echo e(__('Post Status')); ?></th>
                                    <th><?php echo e(__('Created At')); ?></th>
                                    <th><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade-scale" id="modal1" tabindex="-1" role="dialog" aria-labelledby="modal1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="submit-loader">
                <img src="" alt="">
            </div>
            <div class="modal-header">
                <h5 class="modal-title"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
            </div>
        </div>
    </div>
</div>






<div class="modal fade-scale" id="confirm-delete-option" tabindex="-1" role="dialog" aria-labelledby="modal1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header d-block text-center">
                <h4 class="modal-title d-inline-block"><?php echo e(__('Confirm Delete')); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <p class="text-center">
                    <?php echo e(__('You are trying to delete post.')); ?>

                </p>
                <p class="text-center"><?php echo e(__('Do you want to proceed?')); ?></p>
            </div>

            <!-- Modal footer -->
            <div class="modal-footer justify-content-center">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger bulk-delete"><?php echo e(__('Delete')); ?></a>
            </div>

        </div>
    </div>
</div>





<div class="modal fade-scale" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="modal1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header d-block text-center">
                <h4 class="modal-title d-inline-block"><?php echo e(__('Confirm Delete')); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <p class="text-center">
                    <?php echo e(__('You are trying to delete post.')); ?>

                </p>
                <p class="text-center"><?php echo e(__('Do you want to proceed?')); ?></p>
            </div>

            <!-- Modal footer -->
            <div class="modal-footer justify-content-center">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger btn-ok"><?php echo e(__('Delete')); ?></a>
            </div>

        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
    "use strict";

    var table;

     table = $('#geniustable').DataTable({
        ordering: false,
        processing: true,
        serverSide: true,
        ajax: '<?php echo e(route('user.post.datatables')); ?>',
        columns: [
            {data: 'image_big',name: 'image_big'},
            {data: 'title',name: 'title'},
            {data: 'category_id',name: 'category_id'},
            {data: 'language_id',name: 'language_id'},
            {data: 'post_type',name: 'post_type'},
            {data: 'is_approve',name: 'is_approve'},
            {data: 'created_at',name: 'created_at'},
            {data: 'action',searchable: false,orderable: false}
        ],
        language: {
            processing: '<img src="<?php echo e(asset('assets/images/'.$gs->admin_loader)); ?>">'
        },
        drawCallback: function (settings) {
            $('.select').niceSelect();
        }
    });

</script>

<script src="<?php echo e(asset('assets/admin/js/post.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/bulk.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\xampp\htdocs\project\resources\views/user/post/index.blade.php ENDPATH**/ ?>